/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.js.debug.core.model.IJSInspectExpression;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class JSInspectExpression
extends PlatformObject
implements IJSInspectExpression {
    private IWatchExpressionResult fResult;
    private String fExpression;
    private IValue fValue;
    private IDebugEventSetListener debugEventSetListener;

    public JSInspectExpression(String expression, IValue value) {
        this.fExpression = expression;
        this.fValue = value;
        this.debugEventSetListener = new DebugEventSetListener();
        DebugPlugin.getDefault().addDebugEventListener(this.debugEventSetListener);
    }

    public JSInspectExpression(IWatchExpressionResult result) {
        this(result.getExpressionText(), result.getValue());
        this.fResult = result;
    }

    public boolean hasErrors() {
        return this.fResult != null && this.fResult.hasErrors();
    }

    public String[] getErrorMessages() {
        return JSInspectExpression.getErrorMessages(this.fResult);
    }

    public String getExpressionText() {
        return this.fExpression;
    }

    public IValue getValue() {
        return this.fValue;
    }

    public IDebugTarget getDebugTarget() {
        if (this.fValue != null) {
            return this.fValue.getDebugTarget();
        }
        return null;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener(this.debugEventSetListener);
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    private static String[] getErrorMessages(IWatchExpressionResult result) {
        if (result == null) {
            return new String[0];
        }
        String[] messages = result.getErrorMessages();
        if (messages.length > 0) {
            return messages;
        }
        DebugException exception = result.getException();
        if (exception != null) {
            return new String[]{exception.getMessage()};
        }
        return new String[0];
    }

    private class DebugEventSetListener
    implements IDebugEventSetListener {
        private DebugEventSetListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = debugEventArray[n2];
                if (event.getKind() == 8 && event.getSource().equals(JSInspectExpression.this.getDebugTarget())) {
                    DebugPlugin.getDefault().getExpressionManager().removeExpression((IExpression)JSInspectExpression.this);
                }
                ++n2;
            }
        }
    }
}

